#include "lib/lglib.h"
#include "bin/binaries.h"
//#include "music/modules.h"
//#include "music/samples.h"

typedef struct{
	int x1;
	int y1;
	int x2;
	int y2;
	int x3;
	int y3;
}sTriangle;

typedef struct {
	sTriangle t;
	void* n;
}sFace;

typedef struct{
	sFace* f;
	int x;
	int y;
}sModel;

typedef struct{
	sModel m;
	int* bezier_list;
	int bezx;
	int bezy;
	int step;
	int x;
	int y;
	int hp;
	int shootcooldown;
	int currentcooldown;
}sEnemy;

typedef struct{
	int xfixed;
	int yfixed;
	int xinc;
	int yinc;
	int x;
	int y;
}sBullet;

typedef struct{
	int x;
	int y;
	int xinc;
	int yinc;
	int strength;
}sExplosionParticle;

typedef struct{
	int time;
	sFace* f;
	int* bezierpath;
	int bezx;
	int bezy;
	int hp;
	int shootcooldown;
}sEnemyEntry;

struct{
	sModel m;
	int x;
	int y;
	int shootcooldown;
}player;

#define PLAYER_BULLETS 64
#define ENEMY_BULLETS 64
#define MAX_ENEMIES 32
#define MAX_EXPLOSIONPARTICLES 80

sBullet playerbullets[PLAYER_BULLETS];
sBullet enemybullets[ENEMY_BULLETS];
sEnemy enemies[MAX_ENEMIES];
sExplosionParticle exp_particle[MAX_EXPLOSIONPARTICLES];

volatile int active_enemies;
volatile int active_playerbullets;
volatile int active_enemybullets;
volatile int active_explosionparticles;


void IWRAM_CODE DrawLine(int x1, int y1, int x2, int y2, u8 color);
void IWRAM_CODE DrawModel(sModel* m);

void InitLevel(void);
void UpdateLevel(void);

int IWRAM_CODE CheckModelCollision(sModel* m, int px, int py);

int IWRAM_CODE CalcBezierPosition(int p1, int p2, int p3, int p4, int step);

void NewEnemy(sFace* f, int* bezierlist, int bez_xoff, int bez_yoff, int hp, int shootcooldown);
void EnemiesUpdate(void);
void FlushEnemy(int number);

void PlayerUpdate(void);

void IWRAM_CODE BulletsUpdate();


void IWRAM_CODE CreateRandomExplosionParticle(int x, int y);
void IWRAM_CODE ParticlesUpdate(void);




